# -*- coding: utf-8 -*-

from django.utils.translation import ugettext_lazy as _

from events.common_app.disk_admin import DiskAdminAPIClient
from events.surveyme_integration.variables.base import BaseVariableCategory, BaseVariable


class DiskVariableCategory(BaseVariableCategory):
    name = 'disk'
    title = _('Диск')
    order = 11


class DiskCarmaVariable(BaseVariable):
    name = 'disk.carma'
    title = _('Карма')
    category = DiskVariableCategory()

    def get_value(self, format_name=None):
        if not self.answer.user.is_anonymous:
            return DiskAdminAPIClient().get_carma(uid=self.answer.user.uid)


class DiskIsPaidVariable(BaseVariable):
    name = 'disk.is_paid'
    title = _('Платный диск')
    category = DiskVariableCategory()

    def get_value(self, format_name=None):
        if not self.answer.user.is_anonymous:
            return DiskAdminAPIClient().is_paid(uid=self.answer.user.uid)


class DiskIsPaidPsBillingVariable(BaseVariable):
    name = 'disk.is_paid_ps_billing'
    title = _('Платный диск для бизнеса')
    category = DiskVariableCategory()

    def get_value(self, format_name=None):
        if not self.answer.user.is_anonymous:
            return DiskAdminAPIClient().is_paid_ps_billing(uid=self.answer.user.uid)
