# -*- coding: utf-8 -*-
from events.surveyme_integration.variables.fields_restrictions.base import (
    BaseRestriction,
)
from events.surveyme_integration.variables import (
    UserEmailVariable,
    RequestQueryParamVariable,
    FormQuestionAnswerVariable,
)


class EmailFromAddressRestriction(BaseRestriction):
    field_name = 'email_from_address'
    variables_classes = [
        UserEmailVariable,
        RequestQueryParamVariable,
        FormQuestionAnswerVariable,
    ]
    filters = {
        FormQuestionAnswerVariable.name: {
            'question': {
                'answer_type': [
                    'answer_non_profile_email',
                    'param_subscribed_email',
                ],
            },
        },
    }


class EmailToAddressRestriction(EmailFromAddressRestriction):
    field_name = 'email_to_address'
