# -*- coding: utf-8 -*-
from events.surveyme_integration.variables.fields_restrictions.base import (
    BaseRestriction
)
from events.surveyme_integration.variables import (
    UserLoginB2BVariable,
    UserHeadVariable,
    FormQuestionAnswerVariable,
    RequestQueryParamVariable,
)


class StartrekAuthorRestriction(BaseRestriction):
    field_name = 'startrek.author'
    variables_classes = [
        FormQuestionAnswerVariable,
        UserLoginB2BVariable,
        UserHeadVariable,
        RequestQueryParamVariable,
    ]


class StartrekAssigneeRestriction(StartrekAuthorRestriction):
    field_name = 'startrek.assignee'
