# -*- coding: utf-8 -*-

import logging

from django.utils.translation import ugettext_lazy as _

from events.surveyme_integration.variables.base import BaseVariableCategory, BaseVariable
from events.common_app.music import MusicStatusClient


logger = logging.getLogger(__name__)


class MusicVariableCategory(BaseVariableCategory):
    name = 'music'
    title = _('Музыка')
    order = 13


class MusicStatusVariable(BaseVariable):
    name = 'music.status'
    title = _('Статус подписки')
    category = MusicVariableCategory()

    def get_value(self, **kwargs):
        try:
            return self._get_value(**kwargs)
        except Exception:
            logger.exception('Got error while receiving music subscription status')

    def _get_value(self, **kwargs):
        if not self.answer.user.is_anonymous:
            return self.get_status(uid=self.answer.user.uid)

    def get_status(self, uid):
        client = MusicStatusClient()
        return client.get_status(uid)
