# -*- coding: utf-8 -*-
from django.conf import settings
from django.db.models import Sum
from django.utils.translation import ugettext_lazy as _

from events.accounts.models import User
from events.balance.models import BalanceOrder
from events.surveyme_integration.variables.base import BaseVariableCategory, BaseVariable
from events.surveyme_keys.models import SurveyKeysBundle


class OrderVariableCategory(BaseVariableCategory):
    name = 'order'
    title = _('Заказ')
    order = 14


class OrderKeysFromBundleVariable(BaseVariable):
    name = 'order.generate_keys_in_bundle'
    title = _('Ключи доступа к форме')
    category = OrderVariableCategory()
    arguments = ['survey_keys_bundle']

    def __init__(self, survey_keys_bundle, **kwargs):
        super(OrderKeysFromBundleVariable, self).__init__(**kwargs)
        self.survey_keys_bundle = survey_keys_bundle

    def get_value(self, format_name=None):
        bundle = SurveyKeysBundle.objects.get(id=self.survey_keys_bundle)
        keys_count = BalanceOrder.objects.filter(order=self.trigger_data.get('order_id')).aggregate(
            Sum('quantity')
        ).get('quantity__sum')
        if keys_count:
            keys = bundle.generate_keys(
                count=keys_count,
                user_id=User.objects.get(pk=settings.ROBOT_USER_ID).pk,
                is_available=False,
                source='integration',
                integration_id=self.notification_id
            )
            if keys:
                frontend_urls = [i.get_frontend_url() for i in sorted(keys, key=lambda x: x.id or 1)]
                return '\n'.join(['- %s' % i for i in frontend_urls])
