# -*- coding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _

from events.surveyme.dataclasses import Answer, AnswerQuestion
from events.surveyme_integration.variables.base import BaseVariable, BaseVariableCategory


class QuizVariableCategory(BaseVariableCategory):
    name = 'quiz'
    title = _('Результаты теста')
    order = 4


class QuizTotalScores(BaseVariable):
    name = 'quiz.total_scores'
    title = _('Максимум баллов в тесте')
    category = QuizVariableCategory()

    def get_value(self, format_name=None):
        answer = Answer(self.answer.data)
        return answer.quiz.total_scores


class QuizQuestionCount(BaseVariable):
    name = 'quiz.question_count'
    title = _('Всего вопросов с баллами')
    category = QuizVariableCategory()

    def get_value(self, format_name=None):
        answer = Answer(self.answer.data)
        return answer.quiz.question_count


class QuizAnswerScores(BaseVariable):
    name = 'quiz.answer_scores'
    title = _('Набрано баллов')
    category = QuizVariableCategory()

    def get_value(self, format_name=None):
        answer = Answer(self.answer.data)
        return answer.quiz.scores


class QuizResultTitle(BaseVariable):
    name = 'quiz.title'
    title = _('Заголовок результатов теста')
    category = QuizVariableCategory()

    def get_value(self, format_name=None):
        answer = Answer(self.answer.data)
        return answer.quiz.title


class QuizResultDescription(BaseVariable):
    name = 'quiz.description'
    title = _('Описание результатов теста')
    category = QuizVariableCategory()

    def get_value(self, format_name=None):
        answer = Answer(self.answer.data)
        return answer.quiz.description


class QuizQuestionScores(BaseVariable):
    name = 'quiz.question_scores'
    title = _('Набрано баллов на вопросе')
    category = QuizVariableCategory()
    arguments = ['question']

    def __init__(self, question, **kwargs):
        super().__init__(**kwargs)
        self.question = question

    def get_value(self, format_name=None):
        answer_data = self.answer.as_dict()
        answer_question = AnswerQuestion(answer_data.get(self.question))
        return answer_question.scores
