# -*- coding: utf-8 -*-
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from events.surveyme_integration.variables.base import BaseVariableCategory, BaseVariable


class UserVariableCategory(BaseVariableCategory):
    name = 'user'
    title = _('Данные пользователя')
    order = 2


class UserNameVariable(BaseVariable):
    name = 'user.name'
    title = _('Имя')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return ' '.join([personal_data.name, personal_data.surname])


class UserLoginVariable(BaseVariable):
    name = 'user.login'
    title = _('Логин')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.login


class UserLoginB2BVariable(BaseVariable):
    name = 'user.login_b2b'
    title = _('Логин')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.login


class UserUIDVariable(BaseVariable):
    name = 'user.uid'
    title = _('UID')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        if not settings.IS_BUSINESS_SITE:
            return self.answer.user.uid


class UserEmailsVariable(BaseVariable):
    # todo: me
    name = 'user.emails'
    title = _('Все Email адреса')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.email


class UserEmailVariable(BaseVariable):
    name = 'user.email'
    title = _('Электронная почта')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.email


class UserPublicIdVariable(BaseVariable):
    name = 'user.public_id'
    title = _('Public id')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.public_id


class UserKarmaVariable(BaseVariable):
    name = 'user.karma'
    title = _('Карма')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.karma


class UserGenderVariable(BaseVariable):
    name = 'user.gender'
    title = _('Пол')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.gender


class UserDepartmentNameVariable(BaseVariable):
    name = 'user.department'
    title = _('Отдел')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, *args, **kwargs):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.job_place


class UserPhoneVariable(BaseVariable):
    name = 'user.phone'
    title = _('Телефон')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, *args, **kwargs):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.phone


class UserHeadVariable(BaseVariable):
    name = 'user.head'
    title = _('Руководитель')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, *args, **kwargs):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.manager


class UserGroupsVariable(BaseVariable):
    name = 'user.group'
    title = _('Команда')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, *args, **kwargs):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.groups


class UserKarmaStatusVariable(BaseVariable):
    name = 'user.karma_status'
    title = _('Статус кармы')
    category = UserVariableCategory()
    connect_only = True

    def get_value(self, format_name=None):
        personal_data = self.answer.personal_data
        if personal_data:
            return personal_data.karma_status
