# -*- coding: utf-8 -*-
import django_filters

from django_filters.filters import NumberFilter, BaseInFilter

from events.surveyme_keys.models import SurveyKeysBundle, Key
from events.rest_framework_contrib import queryset_filters


class NumberInFilter(BaseInFilter, NumberFilter):
    pass


class SurveyKeysBundleFilter(django_filters.FilterSet):
    class Meta:
        model = SurveyKeysBundle
        fields = (
            'survey',
        )


class KeyFilter(django_filters.FilterSet):
    id__in = NumberInFilter(field_name='id', lookup_expr='in')
    search = queryset_filters.MethodFilter('filter_by_fit_for_search_text')

    class Meta:
        model = Key
        fields = (
            'bundle',
            'user',
        )
