# -*- coding: utf-8 -*-
from django.db.models import Count
from rest_framework import viewsets, status
from rest_framework.response import Response
from rest_framework.decorators import action

from events.rest_framework_contrib.mixins import InternalGenericApiViewV2MixinWithPermissions
from events.surveyme_keys.models import SurveyKeysBundle, Key
from events.surveyme_keys.api_admin.v2.filters import SurveyKeysBundleFilter, KeyFilter
from events.surveyme_keys.api_admin.v2.serializers import SurveyKeysBundleSerializer, KeySerializer


class SurveyKeysBundleViewSet(InternalGenericApiViewV2MixinWithPermissions, viewsets.ModelViewSet):
    serializer_class = SurveyKeysBundleSerializer
    queryset = SurveyKeysBundle.objects.annotate(keys_count=Count('keys'))
    filter_class = SurveyKeysBundleFilter

    @action(methods=['post'], url_path='generate-keys', detail=True)
    def generate_keys(self, request, *args, **kwargs):
        objects = self.get_object().generate_keys(
            count=int(self.request.data.get('count')),
            user_id=request.user.pk,
            is_available=bool(int(self.request.data.get('is_available')))
        )
        return Response({'createdCount': len(objects)})


class KeyViewSet(InternalGenericApiViewV2MixinWithPermissions,
                 viewsets.ModelViewSet):
    serializer_class = KeySerializer
    queryset = Key.objects.select_related('user', 'bundle__survey')
    filter_class = KeyFilter

    def patch(self, request, *args, **kwargs):
        queryset = self.filter_queryset(self.get_queryset())
        for obj in queryset:
            serializer = self.serializer_class(obj, data=request.data, partial=True)
            serializer.is_valid(raise_exception=True)
            serializer.save()

        return Response({}, status=status.HTTP_200_OK)

    def delete(self, request, *args, **kwargs):
        queryset = self.filter_queryset(self.get_queryset())
        for obj in queryset:
            obj.delete()

        return Response({}, status=status.HTTP_200_OK)
