# -*- coding: utf-8 -*-
from django.db.models import Q
from events.common_app.utils import add_model_prefix as add


class KeyConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        # todo: test me
        if model_instance:
            return model_instance.value == search_text
        else:
            condition = Q(**{add(prefix, to='value'): search_text})
        return condition
