# -*- coding: utf-8 -*-
import factory
import factory.django

from events.common_app.utils import generate_code
from events.surveyme.factories import SurveyFactory
from events.surveyme_keys.models import SurveyKeysBundle, Key


class SurveyKeysBundleFactory(factory.django.DjangoModelFactory):
    survey = factory.SubFactory(SurveyFactory)
    name = factory.LazyAttribute(lambda x: 'Bundle of survey %s' % x.survey.id)

    class Meta:
        model = SurveyKeysBundle


class SurveyKeyFactory(factory.django.DjangoModelFactory):
    bundle = factory.SubFactory(SurveyKeysBundle)
    value = factory.LazyAttribute(lambda x: generate_code)

    class Meta:
        model = Key
