# -*- coding: utf-8 -*-
from django.db import models
from django.db.models.query import QuerySet

from events.common_app.managers import ProxyToQuerySetMixin
from events.surveyme_keys.conditions import KeyConditions


class KeyQuerySet(QuerySet):
    def filter_by_fit_for_search_text(self, search_text):
        return self.filter(KeyConditions.is_fit_for_search_text(search_text=search_text))


class KeyManager(ProxyToQuerySetMixin, models.Manager):
    def get_queryset(self):
        return KeyQuerySet(self.model, using=self._db)
