# Generated by Django 2.2.17 on 2020-12-17 06:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from events.common_app.fields import SimpleTextField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('surveyme', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SurveyKeysBundle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='date_of_change')),
                ('name', models.CharField(max_length=200)),
                ('allow_access_to_unpublished_form', models.BooleanField(default=False)),
                ('survey_frontend_base_url', models.CharField(blank=True, max_length=200)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='keys_bundles', to='surveyme.Survey')),
            ],
            options={
                'ordering': ('-date_created',),
            },
        ),
        migrations.CreateModel(
            name='Key',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='date_of_change')),
                ('value', models.CharField(db_index=True, max_length=200)),
                ('is_active', models.BooleanField(default=True)),
                ('date_deactivated', models.DateTimeField(blank=True, null=True)),
                ('is_available', models.BooleanField(default=True)),
                ('note', SimpleTextField(blank=True, verbose_name='примечание')),
                ('source', models.CharField(choices=[('admin', 'Админка'), ('integration', 'Интеграция')], default='admin', max_length=100)),
                ('integration_id', models.CharField(blank=True, max_length=100)),
                ('bundle', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='keys', to='surveyme_keys.SurveyKeysBundle')),
                ('deactivated_by_answer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='keys', to='surveyme.ProfileSurveyAnswer')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-date_created',),
                'unique_together': {('bundle', 'value')},
            },
        ),
    ]
