# -*- coding: utf-8 -*-
from django.db import models


class TakeoutOperation(models.Model):
    SUCCESS = 'success'
    ERROR = 'error'
    INPROGRESS = 'inprogress'
    STATUS_CHOICES = (
        (SUCCESS, SUCCESS),
        (ERROR, ERROR),
        (INPROGRESS, INPROGRESS),
    )
    user = models.ForeignKey('accounts.User', on_delete=models.CASCADE, related_name='+')
    created = models.DateTimeField(auto_now_add=True, null=True)
    error = models.TextField(null=True)
    task_id = models.CharField(max_length=36)
    status = models.CharField(choices=STATUS_CHOICES, default=INPROGRESS, max_length=16)
    request_id = models.CharField(max_length=48, null=True)

    class Meta:
        unique_together = ('task_id', )
