# -*- coding: utf-8 -*-
import uuid

from events.takeout import utils
from events.takeout.models import TakeoutOperation
from events.celery_app import app


@app.task(bind=True)
def relink_user_answers(self, user_id, new_user_id, request_id=None, task_id=None):
    task_id = task_id or self.request.id or str(uuid.uuid4())
    utils.create_operation(user_id, task_id, request_id=request_id)
    try:
        utils.relink_user_answers(user_id, new_user_id)
    except Exception as e:
        utils.change_operation_status(task_id, TakeoutOperation.ERROR, error=str(e))
    else:
        utils.change_operation_status(task_id, TakeoutOperation.SUCCESS)
