# -*- coding: utf-8 -*-
from rest_framework import viewsets
from rest_framework.decorators import action
from rest_framework.response import Response

from events.rest_framework_contrib.mixins import ExternalGenericApiViewV1Mixin
from events.rest_framework_contrib.permissions import (
    ANY, IsSuperUser, IsAuthenticated, Takeout2ClientOnly,
)
from events.takeout import utils


class TakeoutViewSet(ExternalGenericApiViewV1Mixin, viewsets.GenericViewSet):
    permission_classes = [ANY(IsSuperUser, Takeout2ClientOnly), IsAuthenticated]
    detail = None

    @action(methods=['get'], url_path='status', detail=False)
    def status(self, request, *args, **kwargs):
        request_id = request.query_params.get('request_id')
        tda = utils.TakeoutDeleteAnswers(request.user, request_id)
        return Response(tda.check())

    @action(methods=['post'], url_path='delete', detail=False)
    def delete(self, request, *args, **kwargs):
        request_id = request.query_params.get('request_id')
        tda = utils.TakeoutDeleteAnswers(request.user, request_id)
        return Response(tda.delete())
