# -*- coding: utf-8 -*-
import factory
from django.contrib.contenttypes.models import ContentType
from events.surveyme.models import Survey
from events.tanker.models import TankerKeyset


class TankerKeysetFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = TankerKeyset

    name = factory.Sequence(lambda n: 'surveyme.survey.{n}.name'.format(n=n))
    object_id = factory.Sequence(lambda n: n)
    content_type = factory.LazyAttribute(lambda o: ContentType.objects.get_for_model(Survey))
