# -*- coding: utf-8 -*-
from django.db import models
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType

from events.common_app.fields import JSONFieldForSimpleText


class TankerKeyset(models.Model):
    name = models.CharField(max_length=150)
    content_type = models.ForeignKey(ContentType, on_delete=models.CASCADE)
    object_id = models.PositiveIntegerField()
    content_object = GenericForeignKey('content_type', 'object_id')
    last_updated_at = models.DateTimeField(blank=True, null=True)
    keys = JSONFieldForSimpleText(blank=True, null=True)
    languages = JSONFieldForSimpleText(blank=True, null=True)
