# -*- coding: utf-8 -*-
from django.conf.urls import url

from rest_framework.routers import DefaultRouter

from events.common_storages.api.v1.views_api import FileView
from events.surveyme.views_api import (
    SurveyViewSet,
    SurveyFormView,
    ScoreResultsView,
    AnswerResultsView,
    SurveyStatusView,
)
from events.data_sources.api.views import data_source_view_sets
from events.common_app.views import (
    VersionView,
)
from events.geobase_contrib.views_api import (
    CountryViewSet,
    CityViewSet,
)

from events.captcha.api.v1.views import CaptchaView
from events.surveyme.views import (
    QuestionValidator,
    ErrorView,
    SuccessView,
    ConflictView,
)
from events.surveyme_integration.views import IntegrationResultsView


router = DefaultRouter()
router.root_view_name = 'main_api_path'
router.register(r'surveys', SurveyViewSet)
router.register(r'countries', CountryViewSet, 'country')
router.register(r'cities', CityViewSet, 'city')


# register all public data sources with pagination
# todo: test me
for data_source_view_set in data_source_view_sets:
    clean_name = data_source_view_set.data_source_class.name.replace('_', '-')
    router.register(
        r'data-source/%s' % clean_name,
        data_source_view_set,
        'data-source-%s' % clean_name
    )


urlpatterns = [
    url(r'^surveys/(?P<pk>[\da-f]+)/form/$', SurveyFormView.as_view(), name='survey-form'),
    url(r'^surveys/(?P<slug>[^/.]+)/form/$', SurveyFormView.as_view(), name='survey-form'),
    url(r'^surveys/(?P<pk>[\da-f]+)/status/$', SurveyStatusView.as_view(), name='survey-status'),
    url(r'^scores/(?P<secret_code>[\da-f]+)/$', ScoreResultsView.as_view(), name='score-result'),
    url(r'^answers/(?P<secret_code>[\da-f]+)/$', AnswerResultsView.as_view(), name='answer-result'),
    url(r'^integration-results/$', IntegrationResultsView.as_view(), name='integration-results'),
    url(r'^captcha/$', CaptchaView.as_view(), name='captcha'),
    url(r'^files/$', FileView.as_view(), name='file'),
    url(r'^tests/validator/$', QuestionValidator.as_view(), name='tests-validator'),
    url(r'^tests/error/$', ErrorView.as_view(), name='tests-error'),
    url(r'^tests/success/$', SuccessView.as_view(), name='tests-success'),
    url(r'^tests/conflict/$', ConflictView.as_view(), name='tests-conflict'),
    url(r'^version/$', VersionView.as_view(), name='version'),
]
urlpatterns += router.urls
