# -*- coding: utf-8 -*-
from django.conf.urls import url

from rest_framework.routers import DefaultRouter

from events.accounts.api_admin.v2.views_api import (
    UserMeView,
    UserViewSet,
    GroupViewSet,
)
from events.common_app.api_admin.v2.views_api import (
    ContentTypeViewSet,
    TaskViewSet,
    LanguageViewSet,
    UserMessageViewSet,
    DirectorySuggestView,
)
from events.common_storages.api_admin.v2.views import FileView
from events.data_sources.api_admin.v2.views import (
    DataSourceCategoryView,
    DataSourceView,
)
from events.data_sources.sources import data_sources_list
from events.followme.api_admin.v2.views import ContentFollowerViewSet
from events.geobase_contrib.api_admin.v2.views_api import CityViewSet
from events.surveyme.api_admin.v2.views_api import (
    SurveyViewSet,
    AnswerTypeViewSet,
    SurveyQuestionViewSet,
    SurveyTextViewSet,
    SurveyQuestionShowConditionNodeViewSet,
    SurveyQuestionChoiceViewSet,
    SurveyAgreementViewSet,
    SurveyGroupViewSet,
    ProfileSurveyAnswerViewSet,
    SurveyStateConditionNodeViewSet,
    SurveySubmitConditionNodeViewSet,
    SurveyQuestionHintTypeViewSet,
    SurveyTemplateViewSet,
    SurveyStyleTemplateViewSet,
    TakeoutView,
    SurveyQuizView,
    SurveyBanView,
    AnswerResultsView,
)
from events.history.api_admin.v2.views_api import HistoryEntryViewSet
from events.surveyme_integration.api_admin.v2.views import (
    SurveyHookTriggerViewSet,
    SurveyHookViewSet,
    ServiceTypeViewSet,
    ServiceTypeActionViewSet,
    VariableView,
    FilterView,
    VariableCategoryView,
    ServiceSurveyHookSubscriptionViewSet,
    StatusView,
    IntegrationFileTemplateViewSet,
    HookSubscriptionNotificationViewSet,
    FieldRestrictionView,
)
from events.surveyme_keys.api_admin.v2.views import SurveyKeysBundleViewSet, KeyViewSet
from events.balance.api_admin.v2.views_api import TicketViewSet, OrderViewSet
from events.conditions.api_admin.v2.views_api import ContentTypeAttributeViewSet
from events.startrek.api_admin.v2.views import StartrekFieldViewSet, StartrekQueueView
from events.media.api_admin.v2.views import ImageView


app_name = 'admin_api_v2'

router = DefaultRouter()
router.register(r'content-types', ContentTypeViewSet, basename='content-type')
router.register(r'users', UserViewSet, basename='user')
router.register(r'answer-types', AnswerTypeViewSet, basename='answer-type')
router.register(r'survey-question-choices', SurveyQuestionChoiceViewSet, basename='survey-question-choice')
router.register(r'surveys', SurveyViewSet, basename='survey')
router.register(r'survey-groups', SurveyGroupViewSet, basename='survey-group')
router.register(r'survey-questions', SurveyQuestionViewSet, basename='survey-question')
router.register(r'profile-survey-answers', ProfileSurveyAnswerViewSet, basename='survey-answer')
router.register(r'groups', GroupViewSet, basename='group')
router.register(r'tickets', TicketViewSet, basename='ticket')
router.register(r'content-type-attributes', ContentTypeAttributeViewSet, basename='content-type-attribute')
router.register(r'orders', OrderViewSet, basename='order')
router.register(r'survey-texts', SurveyTextViewSet, basename='survey-text')
router.register(r'survey-state-condition-nodes', SurveyStateConditionNodeViewSet, basename='survey-state-condition-node')
router.register(r'survey-question-show-condition-nodes', SurveyQuestionShowConditionNodeViewSet, basename='survey-question-show-condition-node')
router.register(r'survey-submit-condition-nodes', SurveySubmitConditionNodeViewSet, basename='survey-submit-condition-node')
router.register(r'history-entries', HistoryEntryViewSet, basename='history-entry')
router.register(r'survey-agreements', SurveyAgreementViewSet, basename='survey-agreement')
router.register(r'survey-templates', SurveyTemplateViewSet, basename='survey-template')
router.register(r'tasks', TaskViewSet, basename='task')
router.register(r'languages', LanguageViewSet, basename='language')
router.register(r'cities', CityViewSet, basename='city')
router.register(r'survey-hook-triggers', SurveyHookTriggerViewSet, basename='survey-hook-trigger')
router.register(r'survey-integration-file-templates', IntegrationFileTemplateViewSet, basename='survey-integration-file-template')
router.register(r'survey-hooks', SurveyHookViewSet, basename='survey-hooks')
router.register(r'service-types', ServiceTypeViewSet, basename='service-type')
router.register(r'service-type-actions', ServiceTypeActionViewSet, basename='service-type-action')
router.register(r'survey-question-hint-types', SurveyQuestionHintTypeViewSet, basename='survey-question-hint-type')
router.register(r'service-survey-hook-subscriptions', ServiceSurveyHookSubscriptionViewSet, basename='service-survey-hook-subscription')
router.register(r'hook-subscription-notifications', HookSubscriptionNotificationViewSet, basename='hook-subscription-notification')
router.register(r'notifications', HookSubscriptionNotificationViewSet, basename='notification')
router.register(r'survey-keys-bundles', SurveyKeysBundleViewSet, basename='survey-keys-bundle')
router.register(r'survey-keys', KeyViewSet, basename='survey-key')
router.register(r'survey-style-templates', SurveyStyleTemplateViewSet, basename='survey-style-template')
router.register(r'content-followers', ContentFollowerViewSet, basename='content-follower')
router.register(r'startrek-fields', StartrekFieldViewSet, basename='startrek-field')
router.register(r'messages', UserMessageViewSet, basename='user-messages')
router.register(r'image', ImageView, basename='image')

# register all data sources with pagination for internal usage
# todo: test me
for data_source in data_sources_list:
    if data_source.name not in ('survey_question_choice', 'survey_question_matrix_choice'):
        class DataSourceViewSet(data_source.get_view_class()):
            data_source_class = data_source
        clean_name = data_source.name.replace('_', '-')
        router.register(
            r'data-source/%s' % clean_name,
            DataSourceViewSet,
            basename='data-source-%s' % clean_name
        )

urlpatterns = [
    url(r'^users/me/$', UserMeView.as_view(), name='user-me'),
    url(r'^variable-categories/$', VariableCategoryView.as_view(), name='variable-category'),
    url(r'^variables/$', VariableView.as_view(), name='variable'),
    url(r'^filters/$', FilterView.as_view(), name='filter'),
    url(r'^notification-statuses/$', StatusView.as_view(), name='notification-status'),
    url(r'^data-source-categories/$', DataSourceCategoryView.as_view(), name='data-source-category'),
    url(r'^data-sources/$', DataSourceView.as_view(), name='data-source'),
    url(r'^files/$', FileView.as_view(), name='file'),
    url(r'^startrek-queues/(?P<queue_name>[-\w]+)/$', StartrekQueueView.as_view(), name='startrek-queue'),
    url(r'^fields-restrictions/$', FieldRestrictionView.as_view(), name='fields-restriction'),
    url(r'^takeout/$', TakeoutView.as_view(), name='takeout'),
    url(r'^survey-quiz/(?P<pk>[^/.]+)/$', SurveyQuizView.as_view(), name='survey-quiz'),
    url(r'^survey-ban/(?P<pk>[^/.]+)/$', SurveyBanView.as_view(), name='survey-ban'),
    url(r'^answers/(?P<pk>[^/.]+)/$', AnswerResultsView.as_view(), name='answer-result'),
    url(r'^directory/suggest/$', DirectorySuggestView.as_view(), name='directory-suggest'),
]

urlpatterns += router.urls
