from django.urls import include, path
from django.conf.urls import url
from django.conf import settings
from django.conf.urls.static import static
from django.urls import reverse_lazy
from django.views.generic import RedirectView
from events.common_app.views import RobotsView
from events.v3.api import api

urlpatterns = [
    url(r'robots.txt$', RobotsView.as_view()),
    path(r'v1/', include('events.tech.urls')),
    path(r'1/takeout/', include('events.takeout.urls')),
    path(r'', RedirectView.as_view(url=reverse_lazy('main_api_path'))),
]

if settings.IS_INTERNAL_SITE or settings.IS_BUSINESS_SITE or settings.IS_TEST:
    urlpatterns += [
        path(r'admin/api/v2/', include('events.tech.urls_admin.v2')),
        path(r'v3/', api.urls),
        path(r'idm/', include('events.idm.urls')),
        path(r'support/', include('events.support.urls')),
    ]

urlpatterns += static(
    settings.STATIC_URL,
    document_root=settings.STATIC_ROOT,
)
