# -*- coding: utf-8 -*-
from django.contrib.auth.models import Group
from django.contrib.contenttypes.models import ContentType
from guardian.models import GroupObjectPermission

from events.accounts.models import User


def has_perm(user_or_group, perm, obj):
    if isinstance(user_or_group, User):
        return user_or_group.has_perm(perm, obj)
    if isinstance(user_or_group, Group):
        return GroupObjectPermission.objects.filter(
            content_type=ContentType.objects.get_for_model(obj),
            permission__codename=perm,
            object_pk=str(obj.pk),
            group=user_or_group,
        ).exists()
    raise ValueError('unknown type')
