# -*- coding: utf-8 -*-
from typing import List
from urllib import parse as urlparse

from events.v3.schemas import T, PaginationOut, LinksOut

DEFAULT_PAGE_SIZE = 25


def get_full_path(request, **query_params):
    p = urlparse.urlparse(request.get_full_path())
    q = urlparse.parse_qs(p.query) or {}
    q.update(query_params)
    return urlparse.urlunsplit(('', '', p.path, urlparse.urlencode(q, doseq=True), ''))


def get_pagination_out(request, result: List[T], page_size: int = None) -> PaginationOut[T]:
    page_size = page_size or DEFAULT_PAGE_SIZE
    next_url = None
    if len(result) == page_size:
        next_url = get_full_path(request, id=result[-1].id)
    return PaginationOut[T](links=LinksOut(next=next_url), result=result)
