# -*- coding: utf-8 -*-
from typing import List

from events.v3.router import ContextRouter
from events.v3.perms import logged_user
from events.v3.schemas import (
    DetailedNotificationOut, ListNotificationOut,
    RestartNotificationOut, StatusNotificationOut,
)
from events.v3.views.notifications import (
    get_notification_view, get_notifications_view,
    restart_notification_view, restart_notifications_view,
    status_notification_view, status_notifications_view,
)

router = ContextRouter()


router.post('/restart/',
            auth=logged_user, response=List[RestartNotificationOut],
            exclude_none=True)(restart_notifications_view)
router.post('/status/',
            auth=logged_user, response=List[StatusNotificationOut],
            exclude_none=True)(status_notifications_view)
router.post('/{notification_id}/restart/',
            auth=logged_user, response=RestartNotificationOut,
            exclude_none=True)(restart_notification_view)
router.get('/{notification_id}/status/',
           auth=logged_user, response=StatusNotificationOut,
           exclude_none=True)(status_notification_view)

router.get('/{notification_id}/',
           auth=logged_user, response=DetailedNotificationOut,
           exclude_none=True)(get_notification_view)
router.get('/',
           auth=logged_user, response=ListNotificationOut,
           exclude_none=True)(get_notifications_view)
