# -*- coding: utf-8 -*-
from typing import List

from events.v3.router import ContextRouter
from events.v3.perms import logged_user
from events.v3.schemas import OperationInfoOut
from events.v3.views.operations import get_operation_info_view, get_operations_info_view, post_operations_info_view


router = ContextRouter()


router.get('/{operation_id}/', auth=logged_user, response=OperationInfoOut)(get_operation_info_view)
router.get('/', auth=logged_user, response=List[OperationInfoOut])(get_operations_info_view)
router.post('/', auth=logged_user, response=List[OperationInfoOut])(post_operations_info_view)
