# -*- coding: utf-8 -*-
from typing import List

from events.v3.router import ContextRouter
from events.v3.perms import logged_user
from events.v3.schemas import SurveyGroupOut, PermissionOut
from events.v3.views.surveygroups import (
    get_surveygroup_view,
    get_surveygroup_access_view,
    post_surveygroup_access_view,
)

router = ContextRouter()


router.get('/{surveygroup_id}/',
           auth=logged_user, response=SurveyGroupOut, exclude_none=True)(get_surveygroup_view)
router.get('/{surveygroup_id}/access/',
           auth=logged_user, response=List[PermissionOut], exclude_none=True)(get_surveygroup_access_view)
router.post('/{surveygroup_id}/access/',
            auth=logged_user, response=List[PermissionOut], exclude_none=True)(post_surveygroup_access_view)
