# -*- coding: utf-8 -*-
from typing import List

from events.v3.router import ContextRouter
from events.v3.perms import logged_user
from events.v3.schemas import (
    ConditionOut,
    HookOut,
    PermissionOut,
    ResultOut,
    SubscriptionOut,
    SurveyOut,
    VariableInfoOut,
)
from events.v3.views.surveys import (
    get_survey_access_view,
    get_survey_view,
    get_variables_view,
    post_survey_access_view,
)
from events.v3.views.hooks import (
    delete_hook_view,
    get_hook_view,
    get_hooks_view,
    patch_hook_view,
    post_hook_view,
)
from events.v3.views.conditions import (
    delete_condition_view,
    get_condition_view,
    get_conditions_view,
    patch_condition_view,
    post_condition_view,
)
from events.v3.views.notifications import (
    hide_subscription_errors_view,
    hide_survey_errors_view,
    get_visible_errors_view,
)
from events.v3.views.subscriptions import (
    delete_subscription_view,
    get_subscription_view,
    get_subscriptions_view,
    patch_subscription_view,
    post_subscription_view,
)

router = ContextRouter()


router.get('/{survey_id}/',
           auth=logged_user, response=SurveyOut, exclude_none=True)(get_survey_view)

router.get('/{survey_id}/hooks/',
           auth=logged_user, response=List[HookOut], exclude_none=True)(get_hooks_view)
router.get('/{survey_id}/hooks/{hook_id}/',
           auth=logged_user, response=HookOut, exclude_none=True)(get_hook_view)
router.post('/{survey_id}/hooks/',
            auth=logged_user, response=HookOut, exclude_none=True)(post_hook_view)
router.patch('/{survey_id}/hooks/{hook_id}/',
             auth=logged_user, response=HookOut, exclude_none=True)(patch_hook_view)
router.delete('/{survey_id}/hooks/{hook_id}/',
              auth=logged_user, exclude_none=True)(delete_hook_view)

router.get('/{survey_id}/hooks/{hook_id}/conditions/',
           auth=logged_user, response=List[ConditionOut], exclude_none=True)(get_conditions_view)
router.get('/{survey_id}/hooks/{hook_id}/conditions/{condition_id}/',
           auth=logged_user, response=ConditionOut, exclude_none=True)(get_condition_view)
router.post('/{survey_id}/hooks/{hook_id}/conditions/',
             auth=logged_user, response=ConditionOut, exclude_none=True)(post_condition_view)
router.patch('/{survey_id}/hooks/{hook_id}/conditions/{condition_id}/',
             auth=logged_user, response=ConditionOut, exclude_none=True)(patch_condition_view)
router.delete('/{survey_id}/hooks/{hook_id}/conditions/{condition_id}/',
              auth=logged_user, exclude_none=True)(delete_condition_view)

router.get('/{survey_id}/hooks/{hook_id}/subscriptions/',
           auth=logged_user, response=List[SubscriptionOut], exclude_none=True)(get_subscriptions_view)
router.get('/{survey_id}/hooks/{hook_id}/subscriptions/{subscription_id}/',
           auth=logged_user, response=SubscriptionOut, exclude_none=True)(get_subscription_view)
router.post('/{survey_id}/hooks/{hook_id}/subscriptions/',
            auth=logged_user, response=SubscriptionOut, exclude_none=True)(post_subscription_view)
router.patch('/{survey_id}/hooks/{hook_id}/subscriptions/{subscription_id}/',
             auth=logged_user, response=SubscriptionOut, exclude_none=True)(patch_subscription_view)
router.delete('/{survey_id}/hooks/{hook_id}/subscriptions/{subscription_id}/',
              auth=logged_user, exclude_none=True)(delete_subscription_view)

router.get('/{survey_id}/show-errors/',
            auth=logged_user, response=List[int], exclude_none=True)(get_visible_errors_view)
router.post('/{survey_id}/hooks/{hook_id}/subscriptions/{subscription_id}/hide-errors/',
            auth=logged_user, response=ResultOut, exclude_none=True)(hide_subscription_errors_view)
router.post('/{survey_id}/hide-errors/',
            auth=logged_user, response=ResultOut, exclude_none=True)(hide_survey_errors_view)

router.get('/{survey_id}/variables/',
            auth=logged_user, response=List[VariableInfoOut], exclude_none=True)(get_variables_view)

router.get('/{survey_id}/access/',
           auth=logged_user, response=List[PermissionOut], exclude_none=True)(get_survey_access_view)
router.post('/{survey_id}/access/',
            auth=logged_user, response=List[PermissionOut], exclude_none=True)(post_survey_access_view)
