# -*- coding: utf-8 -*-
from events.v3.router import ContextRouter
from events.v3.perms import logged_user
from events.v3.schemas import UserOut, UserSettingsSchemaOut
from events.v3.views.users import (
    delete_user_settings_view,
    get_user_view,
    get_user_by_id_view,
    get_user_by_uid_view,
    get_user_settings_view,
    post_user_settings_view,
)


router = ContextRouter()


router.get('/me/', auth=logged_user, response=UserOut, exclude_none=True)(get_user_view)
router.get('/me/settings/',
           auth=logged_user, response=UserSettingsSchemaOut, exclude_none=True)(get_user_settings_view)
router.post('/me/settings/',
            auth=logged_user, response=UserSettingsSchemaOut, exclude_none=True)(post_user_settings_view)
router.delete('/me/settings/', auth=logged_user)(delete_user_settings_view)
router.get('/{user_id}/', auth=logged_user, response=UserOut, exclude_none=True)(get_user_by_id_view)
router.get('/', auth=logged_user, response=UserOut, exclude_none=True)(get_user_by_uid_view)
