# -*- coding: utf-8 -*-
from django.conf import settings

from events.followme.models import ContentFollower
from events.surveyme.models import Survey
from events.v3.schemas import UnsubscribeSchemaOut
from events.v3.types import UnsubscribeStatusType


def unsubscribe_view(request, secret_code: str):
    try:
        content_follower = ContentFollower.objects.using(settings.DATABASE_ROLOCAL).get(
            secret_code=secret_code,
        )
    except ContentFollower.DoesNotExist:
        return UnsubscribeSchemaOut(status=UnsubscribeStatusType.not_subscribed)
    try:
        survey_name = (
            Survey.with_deleted_objects.using(settings.DATABASE_ROLOCAL)
                .values_list('name', named=True)
                .get(pk=content_follower.object_id).name
        )
    except Survey.DoesNotExist:
        survey_name = None
    content_follower.delete()
    return UnsubscribeSchemaOut(status=UnsubscribeStatusType.unsubscribed, survey_name=survey_name)
