# -*- coding: utf-8 -*-
from typing import List

from events.surveyme.models import SurveyGroup
from events.v3.perms import check_perm, change_permissions, get_permissions_out
from events.v3.schemas import SurveyGroupOut, PermissionIn, PermissionOut
from events.v3.utils import get_surveygroup, set_master_db


def get_surveygroup_out(surveygroup: SurveyGroup) -> SurveyGroupOut:
    params = {
        'id': surveygroup.pk,
        'name': surveygroup.name,
    }
    if surveygroup.org:
        params['dir_id'] = surveygroup.org.dir_id
    return SurveyGroupOut(**params)


def get_surveygroup_view(request, surveygroup_id: int) -> SurveyGroupOut:
    model_fields = ['pk', 'name']
    surveygroup = get_surveygroup(surveygroup_id, user=request.user, orgs=request.orgs, only=model_fields)
    check_perm(request.user, surveygroup)
    return get_surveygroup_out(surveygroup)


def get_surveygroup_access_view(request, surveygroup_id: int) -> List[PermissionOut]:
    model_fields = ['pk', 'user_id']
    surveygroup = get_surveygroup(surveygroup_id, user=request.user, orgs=request.orgs, only=model_fields)
    check_perm(request.user, surveygroup)
    return get_permissions_out(surveygroup)


def post_surveygroup_access_view(
    request,
    surveygroup_id: int, data: List[PermissionIn],
) -> List[PermissionOut]:
    model_fields = ['pk', 'user_id']
    surveygroup = get_surveygroup(surveygroup_id, user=request.user, orgs=request.orgs, only=model_fields)
    check_perm(request.user, surveygroup)
    with set_master_db():
        change_permissions(request.user, surveygroup, data)
        return get_permissions_out(surveygroup)
