# -*- coding: utf-8 -*-
import os
import django

from django_pgaas.wsgi import IdempotentWSGIHandler
from django_tools_log_context import request_log_context


class FormsWSGIHandler(IdempotentWSGIHandler):
    def get_response(self, request):
        with request_log_context(request) as log_context:
            response = super().get_response(request)
            log_context.context['request']['status'] = str(response.status_code)
            return response


def get_application():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'events.settings')
    django.setup()
    return FormsWSGIHandler()


application = get_application()
