# -*- coding: utf-8 -*-
from requests.auth import AuthBase

from events.common_app.tvm2_client import get_service_ticket


class TvmAuth(AuthBase):
    tvm_service_header = 'X-Ya-Service-Ticket'

    def __init__(self, tvm2_client_id):
        self.tvm2_client_id = tvm2_client_id
        self.service_ticket = self._get_service_ticket(self.tvm2_client_id)

    def __call__(self, r):
        r.headers[self.tvm_service_header] = self.service_ticket
        return r

    def _get_service_ticket(self, tvm2_client_id):
        return get_service_ticket(tvm2_client_id)


class OAuth(AuthBase):
    auth_header = 'Authorization'

    def __init__(self, token):
        self.token = token

    def __call__(self, r):
        if self.auth_header not in r.headers:
            r.headers[self.auth_header] = 'OAuth %s' % self.token
        return r
