# coding: utf-8
from django.conf import settings


class BaseFormsMixin(object):
    def get_current_host(self, request=None):
        host = None
        # Вначале пытаемся определить по заголовку x-nginx-host
        if request is not None:
            if settings.YAUTH_HOST_HEADER and settings.YAUTH_HOST_HEADER in request.META:
                host = request.META[settings.YAUTH_HOST_HEADER]
        if not host:
            host = settings.HOST
        return host.split(':')[0]

    def authenticate(self, request):
        """
        Тут переопределяем стандартное поведение django_yauth
        там в случае анонима возвращается None и проверяются
        другие бекэнды, ту же мы возвращаем анонима если получили
        его и не проверяем другие бекэнды
        """
        params = self.is_applicable(request)
        if params is not None:
            user = self.apply(**params)
            return user
        return None
