# -*- coding: utf-8 -*-
from django_yauth.middleware import YandexAuthBackendMiddleware

from events.yauth_contrib.user import FormsAnonymousYandexUser


class FormsYandexAuthMiddleware(YandexAuthBackendMiddleware):
    def _should_create_user(self, request, view_func):
        if (
                request.method == 'GET' and not
                getattr(
                    getattr(view_func, 'cls', None),
                    'create_on_missing',
                    True,
                )
        ):
            return False
        return True

    def process_request(self, request):
        super().process_request(request)
        if request.yauser is None:
            request.yauser = FormsAnonymousYandexUser()

    def process_view(self, request, view_func, view_args, view_kwargs):
        create_on_missing = self._should_create_user(request, view_func)
        request.user = request.yauser.get_user(create_on_missing=create_on_missing)
