from urllib.parse import urlparse

from ylog.context import log_context
from .app import get_destination_url, response_strategy, get_request_id
from .cache import cache_status
from .logger import logger
from .responses import NoUrlResponse, InternalErrorResponse
from .auth import login_required


@login_required
def ye_olde_cheshire_cheese(request, start_resp_callback):
    """
    Actual response handler, working with uwsgi

    @link: http://wiki.yandex-team.ru/intranet/hidereferer
    """
    request_id = get_request_id(request)
    with log_context(request_id=request_id):
        dest_url, lang = get_destination_url(request)
        # обработка запроса
        if not dest_url:
            response = NoUrlResponse()
        else:
            try:
                response = response_strategy(dest_url, request)
            except Exception:
                cache_status(urlparse(dest_url), False, '')

                logger.exception('Unhandled error occured while processing URL "%s"' % dest_url)
                response = InternalErrorResponse()

        response = response.start(dest_url, language=lang, callback=start_resp_callback)

        if isinstance(response, str):
            response = response.encode('utf-8')

        return response
