# -*- coding: utf-8 -*-

import imghdr
import mimetypes

META_CONTENT = ('text', 'application', 'image')

mimetypes.init()


def guess_type(url):
    '''
    Given url returns content type of the content behind the url

    Very quick guessing compared to extract_content_type
    @see: extract_content_type
    '''
    return mimetypes.guess_type(url, False)


def guess_image_type(content):
    '''
    A slow algorithm to get content type of document behind the url

    Tries to read a few bytes of document behind the url
    Uses cache to avoid a lot of requests
    '''
    return imghdr.what(None, h=content),content
