# coding: utf-8
import traceback

from . import settings
from .logger import logger


def detect_language(header):
    """
    Return language code based on HTTP_ACCEPT_LANGUAGE
    http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.4
    """

    def parse_value():
        """
        Return list of languages (cut by lang type if en-gb, etc..)
        ordered by browser preference
        """

        def split_lang():
            """
            Make list of lists [[string lang,int q],...]
            """
            langs = []
            for l in [l.lstrip().split(';') for l in header.split(',')]:
                l = [code.lstrip() for code in l]
                if len(l) == 1:
                    l.append(1)
                else:
                    l[1] = float(l[1][2:])
                l[0] = l[0].split('-')[0]
                langs.append(l)
            return langs

        langs = split_lang()

        #sorting
        langs.sort(key=lambda e: e[1], reverse=True)
        if not any(l[0] == '*' for l in langs):
            return [l[0] for l in langs], []
        desired = []
        undesired = []
        d = desired

        for l in langs:
            if l[0] == '*':
                d = undesired
            else:
                d.append(l)
        return [l[0] for l in desired], [l[0] for l in undesired]

    if not header:
        return settings.LANG_DEFAULT
    try:
        desired, undesired = parse_value()

        logger.debug(' '.join([
            'parsed values', ' '.join(desired), ' '.join(undesired)
        ]))

        for lang in desired:
            if lang in settings.LANGUAGE_CODES:
                logger.debug(('desired is' + lang))
                return lang

        if not undesired:
            logger.debug('undesired is empty, so..')
            return settings.LANG_DEFAULT

        for code in settings.LANGUAGE_CODES:
            if code not in undesired:
                logger.debug('return first that can be returned')
                return code

        logger.debug(('by default return ' + settings.LANG_DEFAULT))
        return settings.LANG_DEFAULT

    except Exception as exc:
        logger.exception('could not detect desired language')
        return settings.LANG_DEFAULT
