# coding: utf-8

import os

LANG_EN = 'en'
LANG_RU = 'ru'
LANG_DEFAULT = LANG_EN

LANGUAGE_CODES = (
    LANG_EN,
    LANG_RU
)


USER_AGENT = 'Mozilla/5.0 (X11; U; Linux i686; ru; rv:1.9.2.15) Gecko/20110303 Ubuntu/10.10 (maverick) Firefox/3.6.15'

DEFAULT_PROTOCOL = 'http'

MIME_TYPES = ('jpeg', 'gif', 'png', 'bmp',)

# domains, whose subdomains are safe to redirect
TRUSTED_DOMAINS = (
    'yandex.ru',
    'yandex-team.ru',
    'yandex.net',
    'yandex.com',
    'yandex.by',
    'yandex.kz',
    'yandex.ua',
    'yandex.com.tr',
    'yadi.sk',
)

# domains, where we will replace http scheme with https
REPLACE_SHEME_FOR = (
    'jing.yandex-team.ru',
)

# на эти домены происходит META-редирект
REFERRER_LEAKS = (
    'fotki.yandex.ru',
    'narod2.yandex.ru',
    'narod.yandex.ru',
    'metrika.yandex.ru',
    'yabs.yandex.ru',
    'maps.yandex.ru',
    'zen.yandex.ru',
)

CACHE = {
    'timeout': {
        'hours': 4
    },
}

GOOD_CACHE_STATUS_TIMEOUT = 10 * 60  # 10 mins
BAD_CACHE_STATUS_TIMEOUT = 5  # seconds

DEBUG = bool(int(os.getenv('DEBUG', 0)))

MEMCACHED_HOST = '127.0.0.1:11211'

# Имя куки для хранения id сессии. Менять не нужно.
SESSIONID_COOKIE_NAME = 'Session_id'

LOGIN_URL = 'https://passport.yandex-team.ru/passport?mode=auth&'
COOKIE_RENEW_URL = 'https://passport.yandex-team.ru/auth/update/?'

BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'

WHITE_LIST = {
    'http%3A%2F%2Fwww.youtube.com%2Fchannel%2FUCTUyoZMfksbNIHfWJjwr5aQ',
    'https%3A%2F%2Fvk.com%2Fyandex.academy',
    'https%3A%2F%2Facademy.yandex.ru%2F',
    'http%3A%2F%2Ftech.yandex.ru%2Feducation%2Fm%2Fshad%2F',
    'http%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Dw4aXvy73l24',
    'https%3A%2F%2Fvk.com%2Fyandex.academy'
}

REDIRECTOR_URL = 'https://sba.yandex.net/safety?url={url}&client={client}'
REDIRECTOR_CLIENT_ID = 'hidereferer'

INFECTED_LINK_CAUTION_PAGE = 'https://yandex.ru/safety/?url={link}'
