# coding: utf-8

import json
from urllib.request import urlopen
from urllib.parse import quote

from ..settings import REDIRECTOR_URL, REDIRECTOR_CLIENT_ID
from ..logger import logger


# https://wiki.yandex-team.ru/users/hulan/Redirector-and-Infected-services/#primeryzaprosovnasafetyinformacijaprourl
def is_infected(url):
    redirector_request_url = REDIRECTOR_URL.format(
        url=quote(url, safe=''),
        client=REDIRECTOR_CLIENT_ID
    )

    try:
        response = urlopen(redirector_request_url, timeout=5)
    except Exception as exc:
        logger.error("Redirector exception: '{}', treat url as safe, url: {}".format(exc, url))
        return False

    try:
        response = json.loads(response.read())
    except ValueError:
        logger.error('Not JSON response from Redirector, treat url as safe, url: {}'.format(url))
        return False

    return len(response['info']) > 0
