import os
import requests

from datetime import date
from typing import Optional

from ids.exceptions import BackendError
from ids.registry import registry
import startrek_client

from src.call_bot.create_service_ticket import create_service_ticket, CreateServiceTicketException

st_host = 'st-api.test.yandex-team.ru'
service = 'staff'
robot_login = 'robot-staff-duty'
defalut_duty_schedule = 'back'

st_host = 'st-api.yandex-team.ru'



duty_aliases = {
    'front': 'фронт',
    'back': 'бек',
}


COMMENT_LACK_OF_PERMISSIONS = (
    '\n\n---\n'
    'I have no permissions in this queue to edit comment. May spam a little if you don\'t give me one.'
)


def is_shift_alias(hint: Optional[str], schedule_name: str):
    if not hint or hint.lower() in schedule_name.lower():
        return True

    alias = duty_aliases.get(hint, None)

    if alias is not None and alias.lower() in schedule_name.lower():
        return True

    return False


def get_duty_login(service_hint: Optional[str], hint: Optional[str], oauth_token: str) -> Optional[str]:
    date_from = date.today()
    date_to = date_from
    fields = ['is_approved', 'person.login', 'schedule.name', 'start', 'end', 'replaces.person.login', 'replaces.schedule.name', 'replaces.start', 'replaces.end']

    query = {
        'date_from': date_from.strftime('%Y-%m-%d'),
        'date_to': date_to.strftime('%Y-%m-%d'),
        'service__slug': service_hint or service,
        'show_in_staff': True,
        'fields': ','.join(fields),
        'with_watcher': 1,
    }

    abc_response = requests.get(
        url='https://abc-back.yandex-team.ru/api/v4/duty/shifts/',
        headers={'Authorization': f'OAuth {oauth_token}'},
        params=query,
        timeout=30,
    )

    schedules = {
        shift['schedule']['name']: shift['person']['login']
        for shift in abc_response.json().get('results', [])
        if shift['is_approved'] and is_shift_alias(hint, shift['schedule']['name'])
    }

    if len(schedules) > 1 and not hint:
        filtered_schedules = {name: login for name, login in schedules.items() if is_shift_alias(defalut_duty_schedule, name)}

        if filtered_schedules:
            return list(filtered_schedules.values())[0]

    if schedules:
        return list(schedules.values())[0]

    if hint:
        return get_duty_login(service_hint, None, oauth_token)

    if service_hint:
        abc_services_response = requests.get(
            url='https://abc-back.yandex-team.ru/api/v4/services/',
            headers={'Authorization': f'OAuth {oauth_token}'},
            params={'slug': service_hint, 'fields': 'parent.slug'},
            timeout=30,
        )
        parents = abc_services_response.json().get('results', [])

        if parents:
            parent = parents[0].get('parent')
            if parent:
                return get_duty_login(parent.get('slug', None), None, oauth_token)

        return get_duty_login(None, None, oauth_token)

    return None




oauth_token = os.getenv('ROBOT_DUTY_OAUTH_TOKEN')

if not oauth_token:
    with open('C:\\Users\\tikhonov-ka\\.ya_token', 'r') as file:
        oauth_token = file.read().rstrip()





repository = registry.get_repository(
    service='startrek2',
    resource_type='issues',
    oauth_token=oauth_token,
    user_agent='python',
    protocol='https',
    host=st_host,
    timeout=30,
)

for issue in repository.get(lookup={'filter': f'pendingReplyFrom:{robot_login}'}):
    issue_key = issue.key
    print('>>>>>>', issue_key)

    comments = [c for c in issue.comments if any(s.login == robot_login for s in c.summonees)]
    last_unhandled_comment_update = None

    for comment in comments:
        summons = [s.login for s in comment.summonees if s.login != robot_login]
        comment_update = {'summonees': summons}

        if comment.text and (comment.text.strip().startswith('/ticket') or comment.text.strip().startswith('/child')):
            try:
                created_issue_key = create_service_ticket(repository, issue, comment)
                comment_update['text'] = created_issue_key + '\n<{origin\n' + comment.text + '\n}>'
            except CreateServiceTicketException as e:
                comment_update['text'] = str(e) + '\n<{origin\n' + comment.text + '\n}>'
        else:
            hints = comment.text.split('\n')[0].split(' ', 1)
            service_hint = hints[0] if hints else None
            duty_hint = hints[1] if len(hints) == 2 else None
            duty_login = get_duty_login(service_hint, duty_hint, oauth_token)
            comment_update['summonees'].append(duty_login)

        try:
            try:
                comment.update(**comment_update)
            except BackendError as st_exception:
                if st_exception.status_code == 403 and st_exception.args[0].startswith('Lack of permissions'):
                    last_unhandled_comment_update = comment_update
                    last_unhandled_comment_update['text'] = (
                        f'<[{comment.text}]>'
                        + comment_update.get('text', '')
                        + COMMENT_LACK_OF_PERMISSIONS
                    )
        except Exception as e:
            print('>>>>>>', f'Comment for {issue_key} update error {e}')

    if last_unhandled_comment_update:
        print('>>>>>>', f'Processing only last comment for {issue_key}')
        issue.comments.create(**last_unhandled_comment_update)
        continue

    if not comments:
        pendingReplyFrom = [x.login for x in issue.pendingReplyFrom if x.login != robot_login]
        issue_update = {'pendingReplyFrom': pendingReplyFrom}

        try:
            issue.update(**issue_update)
        except Exception as e:
            print('>>>>>>', f'Issue {issue_key} update error {e}')
