import os
import json
import requests


st_host = 'st-api.yandex-team.ru'

zbp_teams = {
    '10673': 'Filter: 53044 Status: !Закрыт Queue: Стафф AND (Components: API OR Components: Proposal OR Components: Потолки OR Components: "Интеграция с OEBS" OR Components: Инфраструктура) AND Components: ! hermione_fix_skip AND Priority: !trivial AND Priority: !minor',
}


oauth_token = os.getenv('ROBOT_DUTY_OAUTH_TOKEN')

if not oauth_token:
    with open('C:\\Users\\tikhonov-ka\\.ya_token', 'r') as file:
        oauth_token = file.read().rstrip()


fields = ['key', 'sprint']


for team_id, query in zbp_teams.items():
    team_sprints = requests.get(
        url=f'https://{st_host}/v2/boards/{team_id}/sprints/',
        headers={'Authorization': f'OAuth {oauth_token}'},
        timeout=30,
    ).json()
    team_sprint = next(sprint['id'] for sprint in team_sprints if sprint['status'] == 'in_progress')

    st_response = requests.get(
        url=f'https://{st_host}/v2/issues/',
        headers={'Authorization': f'OAuth {oauth_token}'},
        params={'query': query, 'fields': fields},
        timeout=30,
    )

    for issue_info in st_response.json():
        assigned_sprints = [int(sprint['id']) for sprint in issue_info['sprint']]

        if team_sprint not in assigned_sprints:
            print('>>>>>', issue_info['key'], 'not in current sprint')
            requests.post(
                url=f'https://{st_host}/v2/sprints/{team_sprint}/issues',
                headers={'Authorization': f'OAuth {oauth_token}'},
                data=json.dumps({'key': issue_info['key']}),
                timeout=30,
            )
