import os
import requests

from ids.registry import registry
import startrek_client


st_host = 'st-api.test.yandex-team.ru'
service = 'staff'
robot_login = 'robot-staff-duty'
star_trek_page_size = 1000
star_trek_timeout = 600

st_host = 'st-api.yandex-team.ru'


service_queues = {
    'Стафф': 'STAFF',
}




star_trek_issues_url = f'https://{st_host}/v2/issues/'

oauth_token = os.getenv('ROBOT_DUTY_OAUTH_TOKEN')

if not oauth_token:
    with open('C:\\Users\\tikhonov-ka\\.ya_token', 'r') as file:
        oauth_token = file.read().rstrip()





repository = registry.get_repository(
    service='startrek2',
    resource_type='issues',
    oauth_token=oauth_token,
    user_agent='python',
    protocol='https',
    host=st_host,
    timeout=30,
)


for service, queue in service_queues.items():
    tools_up_query = f'Queue: TOOLSUP AND "ABC Service": "{service}" AND Status: "На стороне сервиса"'

    for issue in requests.get(
        star_trek_issues_url,
        params={'query': tools_up_query, 'perPage': star_trek_page_size, 'expand': 'links'},
        timeout=star_trek_timeout,
        headers={
            'Authorization': f'OAuth {oauth_token}',
            'Content-type': 'application/json',
        },
    ).json():
        issue_key = issue['key']
        service_issue_keys = [
            link['object']['key']
            for link in issue.get('links', [])
            if link['object']['key'].split('-', 1)[0] == queue
        ]
        comment_text = None

        if not service_issue_keys:
            comment_text = f'Нет прилинкованных задач в очереди {queue}, хотя ABC сервис указан {service}'
        else:
            links = requests.get(
                star_trek_issues_url + issue_key + '/links/',
                timeout=star_trek_timeout,
                headers={
                    'Authorization': f'OAuth {oauth_token}',
                    'Content-type': 'application/json',
                },
            ).json()
            links_statuses = {
                link['object']['key']: link['status']['key']
                for link in links
                if link['object']['key'].split('-', 1)[0] == queue
            }

            missing_links = [key for key in service_issue_keys if key not in links_statuses]
            if missing_links:
                print(f'!!!!! Issue {issue_key} permission denied for links {missing_links}')
                continue

            active_service_issues = [key for key, status in links_statuses.items() if status != 'closed']
            if active_service_issues:
                continue

            comment_text = f'Задачи в очереди {queue} закрыты:\n' + '\n'.join(f'- {key}' for key in service_issue_keys)

        if comment_text:
            print('>>>>', issue_key, comment_text)
            try:
                st_issue = repository.get_one(lookup={'query': f'key:{issue_key}'})
                st_issue.transitions['naStoroneSapporta'].execute(comment=comment_text)
            except Exception as e:
                print(f'!!!!! Issue update error {e}')
