from django.conf import settings
from django.db import transaction
from intranet.hrdb_ext.src.lib.startrek import client
from intranet.hrdb_ext.src.amo.exceptions import StartrekException, BadRequestException
from intranet.hrdb_ext.src.amo.models import Ticket, TicketRequest
from intranet.hrdb_ext.src.amo.core.sync import sync_ticket


@transaction.atomic
def process_ticket_request(body, external_id=None):
    ticket = create_startrek_issue(body)
    return TicketRequest.objects.create(
        body=body,
        external_id=external_id,
        ticket=ticket,
    )


def create_startrek_issue(body):
    body.setdefault('queue', settings.AMO_DEFAULT_STARTREK_QUEUE)
    if body['queue'] not in settings.AMO_ALLOWED_STARTREK_QUEUES:
        raise BadRequestException('Invalid queue')

    if settings.AMO_SYSTEM_MARK:
        body.update(settings.AMO_SYSTEM_MARK)

    try:
        issue = client.issues.create(**body)
    except Exception as e:
        raise StartrekException(str(e))

    ticket = Ticket(key=issue.key)
    return sync_ticket(ticket, issue=issue)
