from datetime import datetime, timedelta
from django.conf import settings

from intranet.hrdb_ext.src.amo.models import TicketRequest
from intranet.hrdb_ext.src.amo.serializers import TicketRequestSerializer


def get_requests_statuses(created_after=None, serialize=False):
    if not created_after:
        created_after = datetime.now() - timedelta(days=settings.AMO_DEFAULT_REQUEST_DAYS_DELTA)

    requests = TicketRequest.objects.filter(created_at__gte=created_after)
    if not serialize:
        return requests

    return TicketRequestSerializer(requests, many=True).data
