from intranet.hrdb_ext.src.amo.models import Ticket
from intranet.hrdb_ext.src.lib.startrek import client
from django.conf import settings
from datetime import datetime

import logging

logger = logging.getLogger(__name__)


def get_tickets_filter_query(last_status_changed_at):
    return '({queues}) AND ({updated_at}) AND ({mark})'.format(
        queues=' OR '.join(
            'Queue: {}'.format(queue)
            for queue in settings.AMO_ALLOWED_STARTREK_QUEUES
        ),
        updated_at='"Last status change": >= {}'.format(
            last_status_changed_at.strftime('%Y-%m-%d'),
        ),
        mark=settings.AMO_SYSTEM_MARK_EXTRA_FILTER,
    )


def sync_tickets():
    last_status_changed_at = Ticket.objects.latest('status_changed_at').status_changed_at
    query = get_tickets_filter_query(last_status_changed_at)
    logger.info('Startrek query: {}'.format(query))

    issues = client.issues.find(query=query)
    by_key = {issue.key: issue for issue in issues}
    logger.info('Found {} tickets'.format(len(by_key)))

    tickets = Ticket.objects.filter(key__in=list(by_key.keys()))
    for ticket in tickets:
        issue = by_key[ticket.key]
        sync_ticket(ticket, issue=issue)

    return tickets


def sync_ticket(ticket, issue=None, synced_at=None):
    issue = issue or client.issues[ticket.key]
    synced_at = synced_at or datetime.now()

    ticket.status = issue.status.key
    ticket.created_at = issue.createdAt
    ticket.updated_at = issue.updatedAt
    ticket.status_changed_at = issue.statusStartTime
    ticket.synced_at = synced_at
    ticket.save()

    return ticket


def sync_request_ticket(request):
    if not request.ticket:
        return request

    request.ticket = sync_ticket(request.ticket)
    request.save()
    return request
