from django.db import models
from django.contrib.postgres.fields import JSONField
from datetime import datetime
import uuid


class Ticket(models.Model):
    key = models.CharField(max_length=30, db_index=True)
    status = models.CharField(max_length=30, db_index=True)

    created_at = models.DateTimeField(default=datetime.now)
    updated_at = models.DateTimeField(default=datetime.now)
    status_changed_at = models.DateTimeField(default=datetime.now)
    synced_at = models.DateTimeField(default=datetime.now)


class TicketRequest(models.Model):
    uuid = models.UUIDField(default=uuid.uuid4, editable=False, unique=True)
    external_id = models.CharField(max_length=20, null=True, blank=True, db_index=True)
    created_at = models.DateTimeField(default=datetime.now, db_index=True)
    body = JSONField(default=dict, blank=True)
    error = models.TextField(null=True, blank=True)

    ticket = models.OneToOneField(Ticket, on_delete=models.SET_NULL, null=True)
