from rest_framework.serializers import ModelSerializer
from intranet.hrdb_ext.src.amo.models import TicketRequest, Ticket


class TicketSerializer(ModelSerializer):
    class Meta:
        model = Ticket
        fields = ('key', 'status', 'created_at', 'updated_at', 'synced_at')


class TicketRequestSerializer(ModelSerializer):
    ticket = TicketSerializer()

    class Meta:
        model = TicketRequest
        fields = ['uuid', 'external_id', 'created_at', 'ticket']
