import requests
from django.conf import settings
import logging

from intranet.hrdb_ext.src.celery_app import app
from intranet.hrdb_ext.src.amo.core.sync import sync_tickets
from intranet.hrdb_ext.src.amo.core.search import get_requests_statuses
from intranet.hrdb_ext.src.lib.lock import locked_task

logger = logging.getLogger(__name__)


@app.task()
@locked_task
def sync_tickets_states_with_startrek():
    sync_tickets()


@app.task()
@locked_task
def push_tickets_states_to_amo():
    data = get_requests_statuses(serialize=True)
    response = requests.post(settings.AMO_PUSH_TICKETS_URL, json=data)
    if response.status_code not in [200, 201]:
        logger.error(response.content)


@app.task()
@locked_task
def test_task():
    logger.info('Executing test task')
