from intranet.hrdb_ext.src.ispring.api.repository import BaseRepository
from intranet.hrdb_ext.src.ispring.api.pagination import XmlPage
import attr


@attr.s
class ISpringDepartment:
    department_id = attr.ib()
    code = attr.ib()
    name = attr.ib()
    parent_id = attr.ib(default=None)

    # Used only for staff department.
    # It is not actual for ISpring department.
    is_deleted = attr.ib(default=None)

    @classmethod
    def from_xml(cls, root):
        return cls(
            department_id=getattr(root.find('departmentId'), 'text', None),
            code=getattr(root.find('code'), 'text', None),
            name=getattr(root.find('name'), 'text', None),
            parent_id=getattr(root.find('parentDepartmentId'), 'text', None),
        )

    @classmethod
    def from_staff(cls, staff):
        return cls(
            department_id=staff['department']['id'],
            code=staff['url'],
            name=staff['department']['name']['full']['ru'],
            parent_id=staff['ancestors'][-1]['department']['id'] if staff['ancestors'] else None,
            is_deleted=staff['is_deleted']
        )


class DepartmentPage(XmlPage):
    item_key = 'department'


class DepartmentRepository(BaseRepository):
    page_cls = DepartmentPage
    wrapper = ISpringDepartment
    resource = 'department'
