from intranet.hrdb_ext.src.ispring.api.connector import HttpConnector
from intranet.hrdb_ext.src.ispring.api.pagination import Fetcher, ResultSet


class BaseRepository:
    connector_cls = HttpConnector
    page_cls = None
    wrapper = None
    resource = None

    def __init__(self, **config):
        self.connector = self.connector_cls(**config)

    def get_iter(self, lookup, **params):
        params.setdefault('resource', f'{self.resource}s_iter')
        params['url_vars'] = lookup
        fetcher = Fetcher(self.connector, self.page_cls, **params)
        return ResultSet(fetcher, self.wrapper)

    def get_all(self, lookup, **params):
        params['resource'] = f'{self.resource}s_all'
        return list(self.get_iter(lookup, **params))

    def get_one(self, lookup, **params):
        params['resource'] = self.resource
        for item in self.get_iter(lookup, **params):
            return item
        return None

    def create(self, lookup, body, **params):
        params['resource'] = f'{self.resource}s_all'
        params.setdefault('json', body)
        return self.connector.post(url_vars=lookup, **params)

    def update(self, lookup, body, **params):
        params['resource'] = self.resource
        params.setdefault('json', body)
        return self.connector.post(url_vars=lookup, **params)

    def delete(self, lookup, **params):
        params['resource'] = self.resource
        return self.connector.delete(url_vars=lookup, **params)
